<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd‏/M‏/y',
            'time' => 'h:mm a',
            'datetime' => 'd‏/M‏/y h:mm a',
        ],
        'medium' => [
            'date' => 'dd‏/MM‏/y',
            'time' => 'h:mm:ss a',
            'datetime' => 'dd‏/MM‏/y h:mm:ss a',
        ],
        'long' => [
            'date' => 'd MMMM y',
            'time' => 'h:mm:ss a z',
            'datetime' => 'd MMMM y h:mm:ss a z',
        ],
        'full' => [
            'date' => 'EEEE، d MMMM y',
            'time' => 'h:mm:ss a zzzz',
            'datetime' => 'EEEE، d MMMM y h:mm:ss a zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0%',
        'scientific' => '#E0',
    ],
    'amName' => 'ص',
    'pmName' => 'م',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '؜-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => '٫',
        'groupingSeparator' => '٬',
        'patternSeparator' => ';',
        'percent' => '٪؜',
        'zeroDigit' => '٠',
        'digit' => '#',
        'minusSign' => '؜-',
        'plusSign' => '؜+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => '٫',
        'exponential' => 'اس',
        'permill' => '؉',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'ليس رقم',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '٬',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => 'JP¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => 'US$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'ي',
            'ف',
            'م',
            'أ',
            'و',
            'ن',
            'ل',
            'غ',
            'س',
            'ك',
            'ب',
            'د',
        ],
        'medium' => [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر',
        ],
        'full' => [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'ي',
            'ف',
            'م',
            'أ',
            'و',
            'ن',
            'ل',
            'غ',
            'س',
            'ك',
            'ب',
            'د',
        ],
        'medium' => [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر',
        ],
        'full' => [
            'يناير',
            'فبراير',
            'مارس',
            'أبريل',
            'مايو',
            'يونيو',
            'يوليو',
            'أغسطس',
            'سبتمبر',
            'أكتوبر',
            'نوفمبر',
            'ديسمبر',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'ح',
            'ن',
            'ث',
            'ر',
            'خ',
            'ج',
            'س',
        ],
        'short' => [
            'أحد',
            'إثنين',
            'ثلاثاء',
            'أربعاء',
            'خميس',
            'جمعة',
            'سبت',
        ],
        'medium' => [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت',
        ],
        'full' => [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'ح',
            'ن',
            'ث',
            'ر',
            'خ',
            'ج',
            'س',
        ],
        'short' => [
            'أحد',
            'إثنين',
            'ثلاثاء',
            'أربعاء',
            'خميس',
            'جمعة',
            'سبت',
        ],
        'medium' => [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت',
        ],
        'full' => [
            'الأحد',
            'الاثنين',
            'الثلاثاء',
            'الأربعاء',
            'الخميس',
            'الجمعة',
            'السبت',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'الأفريقانية',
        'af-NA' => 'الأفريقانية (ناميبيا)',
        'af-ZA' => 'الأفريقانية (جنوب أفريقيا)',
        'agq' => 'الأغم',
        'agq-CM' => 'الأغم (الكاميرون)',
        'ak' => 'الأكانية',
        'ak-GH' => 'الأكانية (غانا)',
        'am' => 'الأمهرية',
        'am-ET' => 'الأمهرية (إثيوبيا)',
        'ar' => 'العربية',
        'ar-001' => 'العربية (العالم)',
        'ar-AE' => 'العربية (الإمارات العربية المتحدة)',
        'ar-BH' => 'العربية (البحرين)',
        'ar-DJ' => 'العربية (جيبوتي)',
        'ar-DZ' => 'العربية (الجزائر)',
        'ar-EG' => 'العربية (مصر)',
        'ar-EH' => 'العربية (الصحراء الغربية)',
        'ar-ER' => 'العربية (إريتريا)',
        'ar-IL' => 'العربية (إسرائيل)',
        'ar-IQ' => 'العربية (العراق)',
        'ar-JO' => 'العربية (الأردن)',
        'ar-KM' => 'العربية (جزر القمر)',
        'ar-KW' => 'العربية (الكويت)',
        'ar-LB' => 'العربية (لبنان)',
        'ar-LY' => 'العربية (ليبيا)',
        'ar-MA' => 'العربية (المغرب)',
        'ar-MR' => 'العربية (موريتانيا)',
        'ar-OM' => 'العربية (عُمان)',
        'ar-PS' => 'العربية (الأراضي الفلسطينية)',
        'ar-QA' => 'العربية (قطر)',
        'ar-SA' => 'العربية (المملكة العربية السعودية)',
        'ar-SD' => 'العربية (السودان)',
        'ar-SO' => 'العربية (الصومال)',
        'ar-SS' => 'العربية (جنوب السودان)',
        'ar-SY' => 'العربية (سوريا)',
        'ar-TD' => 'العربية (تشاد)',
        'ar-TN' => 'العربية (تونس)',
        'ar-YE' => 'العربية (اليمن)',
        'as' => 'الأسامية',
        'as-IN' => 'الأسامية (الهند)',
        'asa' => 'الآسو',
        'asa-TZ' => 'الآسو (تنزانيا)',
        'ast' => 'الأسترية',
        'ast-ES' => 'الأسترية (إسبانيا)',
        'az' => 'الأذربيجانية',
        'az-Cyrl' => 'الأذربيجانية (السيريلية)',
        'az-Cyrl-AZ' => 'الأذربيجانية (السيريلية، أذربيجان)',
        'az-Latn' => 'الأذربيجانية (اللاتينية)',
        'az-Latn-AZ' => 'الأذربيجانية (اللاتينية، أذربيجان)',
        'bas' => 'الباسا',
        'bas-CM' => 'الباسا (الكاميرون)',
        'be' => 'البيلاروسية',
        'be-BY' => 'البيلاروسية (بيلاروس)',
        'bem' => 'البيمبا',
        'bem-ZM' => 'البيمبا (زامبيا)',
        'bez' => 'بينا',
        'bez-TZ' => 'بينا (تنزانيا)',
        'bg' => 'البلغارية',
        'bg-BG' => 'البلغارية (بلغاريا)',
        'bm' => 'البامبارا',
        'bm-ML' => 'البامبارا (مالي)',
        'bn' => 'البنغالية',
        'bn-BD' => 'البنغالية (بنغلاديش)',
        'bn-IN' => 'البنغالية (الهند)',
        'bo' => 'التبتية',
        'bo-CN' => 'التبتية (الصين)',
        'bo-IN' => 'التبتية (الهند)',
        'br' => 'البريتونية',
        'br-FR' => 'البريتونية (فرنسا)',
        'brx' => 'البودو',
        'brx-IN' => 'البودو (الهند)',
        'bs' => 'البوسنية',
        'bs-Cyrl' => 'البوسنية (السيريلية)',
        'bs-Cyrl-BA' => 'البوسنية (السيريلية، البوسنة والهرسك)',
        'bs-Latn' => 'البوسنية (اللاتينية)',
        'bs-Latn-BA' => 'البوسنية (اللاتينية، البوسنة والهرسك)',
        'ca' => 'الكتالانية',
        'ca-AD' => 'الكتالانية (أندورا)',
        'ca-ES' => 'الكتالانية (إسبانيا)',
        'ca-FR' => 'الكتالانية (فرنسا)',
        'ca-IT' => 'الكتالانية (إيطاليا)',
        'ccp' => 'ccp',
        'ccp-BD' => 'ccp (بنغلاديش)',
        'ccp-IN' => 'ccp (الهند)',
        'ce' => 'الشيشانية',
        'ce-RU' => 'الشيشانية (روسيا)',
        'ceb' => 'السيبيوانية',
        'ceb-PH' => 'السيبيوانية (الفلبين)',
        'cgg' => 'تشيغا',
        'cgg-UG' => 'تشيغا (أوغندا)',
        'chr' => 'الشيروكي',
        'chr-US' => 'الشيروكي (الولايات المتحدة)',
        'ckb' => 'السورانية الكردية',
        'ckb-IQ' => 'السورانية الكردية (العراق)',
        'ckb-IR' => 'السورانية الكردية (إيران)',
        'cs' => 'التشيكية',
        'cs-CZ' => 'التشيكية (التشيك)',
        'cy' => 'الويلزية',
        'cy-GB' => 'الويلزية (المملكة المتحدة)',
        'da' => 'الدانمركية',
        'da-DK' => 'الدانمركية (الدانمرك)',
        'da-GL' => 'الدانمركية (غرينلاند)',
        'dav' => 'تيتا',
        'dav-KE' => 'تيتا (كينيا)',
        'de' => 'الألمانية',
        'de-AT' => 'الألمانية (النمسا)',
        'de-BE' => 'الألمانية (بلجيكا)',
        'de-CH' => 'الألمانية (سويسرا)',
        'de-DE' => 'الألمانية (ألمانيا)',
        'de-IT' => 'الألمانية (إيطاليا)',
        'de-LI' => 'الألمانية (ليختنشتاين)',
        'de-LU' => 'الألمانية (لوكسمبورغ)',
        'dje' => 'الزارمية',
        'dje-NE' => 'الزارمية (النيجر)',
        'dsb' => 'صوربيا السفلى',
        'dsb-DE' => 'صوربيا السفلى (ألمانيا)',
        'dua' => 'الديولا',
        'dua-CM' => 'الديولا (الكاميرون)',
        'dyo' => 'جولا فونيا',
        'dyo-SN' => 'جولا فونيا (السنغال)',
        'dz' => 'الزونخاية',
        'dz-BT' => 'الزونخاية (بوتان)',
        'ebu' => 'إمبو',
        'ebu-KE' => 'إمبو (كينيا)',
        'ee' => 'الإيوي',
        'ee-GH' => 'الإيوي (غانا)',
        'ee-TG' => 'الإيوي (توغو)',
        'el' => 'اليونانية',
        'el-CY' => 'اليونانية (قبرص)',
        'el-GR' => 'اليونانية (اليونان)',
        'en' => 'الإنجليزية',
        'en-001' => 'الإنجليزية (العالم)',
        'en-150' => 'الإنجليزية (أوروبا)',
        'en-AE' => 'الإنجليزية (الإمارات العربية المتحدة)',
        'en-AG' => 'الإنجليزية (أنتيغوا وبربودا)',
        'en-AI' => 'الإنجليزية (أنغويلا)',
        'en-AS' => 'الإنجليزية (ساموا الأمريكية)',
        'en-AT' => 'الإنجليزية (النمسا)',
        'en-AU' => 'الإنجليزية (أستراليا)',
        'en-BB' => 'الإنجليزية (بربادوس)',
        'en-BE' => 'الإنجليزية (بلجيكا)',
        'en-BI' => 'الإنجليزية (بوروندي)',
        'en-BM' => 'الإنجليزية (برمودا)',
        'en-BS' => 'الإنجليزية (البهاما)',
        'en-BW' => 'الإنجليزية (بوتسوانا)',
        'en-BZ' => 'الإنجليزية (بليز)',
        'en-CA' => 'الإنجليزية (كندا)',
        'en-CC' => 'الإنجليزية (جزر كوكوس [كيلينغ])',
        'en-CH' => 'الإنجليزية (سويسرا)',
        'en-CK' => 'الإنجليزية (جزر كوك)',
        'en-CM' => 'الإنجليزية (الكاميرون)',
        'en-CX' => 'الإنجليزية (جزيرة كريسماس)',
        'en-CY' => 'الإنجليزية (قبرص)',
        'en-DE' => 'الإنجليزية (ألمانيا)',
        'en-DG' => 'الإنجليزية (دييغو غارسيا)',
        'en-DK' => 'الإنجليزية (الدانمرك)',
        'en-DM' => 'الإنجليزية (دومينيكا)',
        'en-ER' => 'الإنجليزية (إريتريا)',
        'en-FI' => 'الإنجليزية (فنلندا)',
        'en-FJ' => 'الإنجليزية (فيجي)',
        'en-FK' => 'الإنجليزية (جزر فوكلاند)',
        'en-FM' => 'الإنجليزية (ميكرونيزيا)',
        'en-GB' => 'الإنجليزية (المملكة المتحدة)',
        'en-GD' => 'الإنجليزية (غرينادا)',
        'en-GG' => 'الإنجليزية (غيرنزي)',
        'en-GH' => 'الإنجليزية (غانا)',
        'en-GI' => 'الإنجليزية (جبل طارق)',
        'en-GM' => 'الإنجليزية (غامبيا)',
        'en-GU' => 'الإنجليزية (غوام)',
        'en-GY' => 'الإنجليزية (غيانا)',
        'en-HK' => 'الإنجليزية (هونغ كونغ الصينية [منطقة إدارية خاصة])',
        'en-IE' => 'الإنجليزية (أيرلندا)',
        'en-IL' => 'الإنجليزية (إسرائيل)',
        'en-IM' => 'الإنجليزية (جزيرة مان)',
        'en-IN' => 'الإنجليزية (الهند)',
        'en-IO' => 'الإنجليزية (الإقليم البريطاني في المحيط الهندي)',
        'en-JE' => 'الإنجليزية (جيرسي)',
        'en-JM' => 'الإنجليزية (جامايكا)',
        'en-KE' => 'الإنجليزية (كينيا)',
        'en-KI' => 'الإنجليزية (كيريباتي)',
        'en-KN' => 'الإنجليزية (سانت كيتس ونيفيس)',
        'en-KY' => 'الإنجليزية (جزر كايمان)',
        'en-LC' => 'الإنجليزية (سانت لوسيا)',
        'en-LR' => 'الإنجليزية (ليبيريا)',
        'en-LS' => 'الإنجليزية (ليسوتو)',
        'en-MG' => 'الإنجليزية (مدغشقر)',
        'en-MH' => 'الإنجليزية (جزر مارشال)',
        'en-MO' => 'الإنجليزية (مكاو الصينية [منطقة إدارية خاصة])',
        'en-MP' => 'الإنجليزية (جزر ماريانا الشمالية)',
        'en-MS' => 'الإنجليزية (مونتسرات)',
        'en-MT' => 'الإنجليزية (مالطا)',
        'en-MU' => 'الإنجليزية (موريشيوس)',
        'en-MW' => 'الإنجليزية (ملاوي)',
        'en-MY' => 'الإنجليزية (ماليزيا)',
        'en-NA' => 'الإنجليزية (ناميبيا)',
        'en-NF' => 'الإنجليزية (جزيرة نورفولك)',
        'en-NG' => 'الإنجليزية (نيجيريا)',
        'en-NL' => 'الإنجليزية (هولندا)',
        'en-NR' => 'الإنجليزية (ناورو)',
        'en-NU' => 'الإنجليزية (نيوي)',
        'en-NZ' => 'الإنجليزية (نيوزيلندا)',
        'en-PG' => 'الإنجليزية (بابوا غينيا الجديدة)',
        'en-PH' => 'الإنجليزية (الفلبين)',
        'en-PK' => 'الإنجليزية (باكستان)',
        'en-PN' => 'الإنجليزية (جزر بيتكيرن)',
        'en-PR' => 'الإنجليزية (بورتوريكو)',
        'en-PW' => 'الإنجليزية (بالاو)',
        'en-RW' => 'الإنجليزية (رواندا)',
        'en-SB' => 'الإنجليزية (جزر سليمان)',
        'en-SC' => 'الإنجليزية (سيشل)',
        'en-SD' => 'الإنجليزية (السودان)',
        'en-SE' => 'الإنجليزية (السويد)',
        'en-SG' => 'الإنجليزية (سنغافورة)',
        'en-SH' => 'الإنجليزية (سانت هيلينا)',
        'en-SI' => 'الإنجليزية (سلوفينيا)',
        'en-SL' => 'الإنجليزية (سيراليون)',
        'en-SS' => 'الإنجليزية (جنوب السودان)',
        'en-SX' => 'الإنجليزية (سانت مارتن)',
        'en-SZ' => 'الإنجليزية (إسواتيني)',
        'en-TC' => 'الإنجليزية (جزر توركس وكايكوس)',
        'en-TK' => 'الإنجليزية (توكيلو)',
        'en-TO' => 'الإنجليزية (تونغا)',
        'en-TT' => 'الإنجليزية (ترينيداد وتوباغو)',
        'en-TV' => 'الإنجليزية (توفالو)',
        'en-TZ' => 'الإنجليزية (تنزانيا)',
        'en-UG' => 'الإنجليزية (أوغندا)',
        'en-UM' => 'الإنجليزية (جزر الولايات المتحدة النائية)',
        'en-US' => 'الإنجليزية (الولايات المتحدة)',
        'en-US-POSIX' => 'الإنجليزية (الولايات المتحدة، حاسوب)',
        'en-VC' => 'الإنجليزية (سانت فنسنت وجزر غرينادين)',
        'en-VG' => 'الإنجليزية (جزر فيرجن البريطانية)',
        'en-VI' => 'الإنجليزية (جزر فيرجن التابعة للولايات المتحدة)',
        'en-VU' => 'الإنجليزية (فانواتو)',
        'en-WS' => 'الإنجليزية (ساموا)',
        'en-ZA' => 'الإنجليزية (جنوب أفريقيا)',
        'en-ZM' => 'الإنجليزية (زامبيا)',
        'en-ZW' => 'الإنجليزية (زيمبابوي)',
        'eo' => 'الإسبرانتو',
        'eo-001' => 'الإسبرانتو (العالم)',
        'es' => 'الإسبانية',
        'es-419' => 'الإسبانية (أمريكا اللاتينية)',
        'es-AR' => 'الإسبانية (الأرجنتين)',
        'es-BO' => 'الإسبانية (بوليفيا)',
        'es-BR' => 'الإسبانية (البرازيل)',
        'es-BZ' => 'الإسبانية (بليز)',
        'es-CL' => 'الإسبانية (تشيلي)',
        'es-CO' => 'الإسبانية (كولومبيا)',
        'es-CR' => 'الإسبانية (كوستاريكا)',
        'es-CU' => 'الإسبانية (كوبا)',
        'es-DO' => 'الإسبانية (جمهورية الدومينيكان)',
        'es-EA' => 'الإسبانية (سيوتا وميليلا)',
        'es-EC' => 'الإسبانية (الإكوادور)',
        'es-ES' => 'الإسبانية (إسبانيا)',
        'es-GQ' => 'الإسبانية (غينيا الاستوائية)',
        'es-GT' => 'الإسبانية (غواتيمالا)',
        'es-HN' => 'الإسبانية (هندوراس)',
        'es-IC' => 'الإسبانية (جزر الكناري)',
        'es-MX' => 'الإسبانية (المكسيك)',
        'es-NI' => 'الإسبانية (نيكاراغوا)',
        'es-PA' => 'الإسبانية (بنما)',
        'es-PE' => 'الإسبانية (بيرو)',
        'es-PH' => 'الإسبانية (الفلبين)',
        'es-PR' => 'الإسبانية (بورتوريكو)',
        'es-PY' => 'الإسبانية (باراغواي)',
        'es-SV' => 'الإسبانية (السلفادور)',
        'es-US' => 'الإسبانية (الولايات المتحدة)',
        'es-UY' => 'الإسبانية (أورغواي)',
        'es-VE' => 'الإسبانية (فنزويلا)',
        'et' => 'الإستونية',
        'et-EE' => 'الإستونية (إستونيا)',
        'eu' => 'الباسكية',
        'eu-ES' => 'الباسكية (إسبانيا)',
        'ewo' => 'الإيوندو',
        'ewo-CM' => 'الإيوندو (الكاميرون)',
        'fa' => 'الفارسية',
        'fa-AF' => 'الفارسية (أفغانستان)',
        'fa-IR' => 'الفارسية (إيران)',
        'ff' => 'الفولانية',
        'ff-Latn' => 'الفولانية (اللاتينية)',
        'ff-Latn-BF' => 'الفولانية (اللاتينية، بوركينا فاسو)',
        'ff-Latn-CM' => 'الفولانية (اللاتينية، الكاميرون)',
        'ff-Latn-GH' => 'الفولانية (اللاتينية، غانا)',
        'ff-Latn-GM' => 'الفولانية (اللاتينية، غامبيا)',
        'ff-Latn-GN' => 'الفولانية (اللاتينية، غينيا)',
        'ff-Latn-GW' => 'الفولانية (اللاتينية، غينيا بيساو)',
        'ff-Latn-LR' => 'الفولانية (اللاتينية، ليبيريا)',
        'ff-Latn-MR' => 'الفولانية (اللاتينية، موريتانيا)',
        'ff-Latn-NE' => 'الفولانية (اللاتينية، النيجر)',
        'ff-Latn-NG' => 'الفولانية (اللاتينية، نيجيريا)',
        'ff-Latn-SL' => 'الفولانية (اللاتينية، سيراليون)',
        'ff-Latn-SN' => 'الفولانية (اللاتينية، السنغال)',
        'fi' => 'الفنلندية',
        'fi-FI' => 'الفنلندية (فنلندا)',
        'fil' => 'الفلبينية',
        'fil-PH' => 'الفلبينية (الفلبين)',
        'fo' => 'الفاروية',
        'fo-DK' => 'الفاروية (الدانمرك)',
        'fo-FO' => 'الفاروية (جزر فارو)',
        'fr' => 'الفرنسية',
        'fr-BE' => 'الفرنسية (بلجيكا)',
        'fr-BF' => 'الفرنسية (بوركينا فاسو)',
        'fr-BI' => 'الفرنسية (بوروندي)',
        'fr-BJ' => 'الفرنسية (بنين)',
        'fr-BL' => 'الفرنسية (سان بارتليمي)',
        'fr-CA' => 'الفرنسية (كندا)',
        'fr-CD' => 'الفرنسية (الكونغو - كينشاسا)',
        'fr-CF' => 'الفرنسية (جمهورية أفريقيا الوسطى)',
        'fr-CG' => 'الفرنسية (الكونغو - برازافيل)',
        'fr-CH' => 'الفرنسية (سويسرا)',
        'fr-CI' => 'الفرنسية (ساحل العاج)',
        'fr-CM' => 'الفرنسية (الكاميرون)',
        'fr-DJ' => 'الفرنسية (جيبوتي)',
        'fr-DZ' => 'الفرنسية (الجزائر)',
        'fr-FR' => 'الفرنسية (فرنسا)',
        'fr-GA' => 'الفرنسية (الغابون)',
        'fr-GF' => 'الفرنسية (غويانا الفرنسية)',
        'fr-GN' => 'الفرنسية (غينيا)',
        'fr-GP' => 'الفرنسية (غوادلوب)',
        'fr-GQ' => 'الفرنسية (غينيا الاستوائية)',
        'fr-HT' => 'الفرنسية (هايتي)',
        'fr-KM' => 'الفرنسية (جزر القمر)',
        'fr-LU' => 'الفرنسية (لوكسمبورغ)',
        'fr-MA' => 'الفرنسية (المغرب)',
        'fr-MC' => 'الفرنسية (موناكو)',
        'fr-MF' => 'الفرنسية (سان مارتن)',
        'fr-MG' => 'الفرنسية (مدغشقر)',
        'fr-ML' => 'الفرنسية (مالي)',
        'fr-MQ' => 'الفرنسية (جزر المارتينيك)',
        'fr-MR' => 'الفرنسية (موريتانيا)',
        'fr-MU' => 'الفرنسية (موريشيوس)',
        'fr-NC' => 'الفرنسية (كاليدونيا الجديدة)',
        'fr-NE' => 'الفرنسية (النيجر)',
        'fr-PF' => 'الفرنسية (بولينيزيا الفرنسية)',
        'fr-PM' => 'الفرنسية (سان بيير ومكويلون)',
        'fr-RE' => 'الفرنسية (روينيون)',
        'fr-RW' => 'الفرنسية (رواندا)',
        'fr-SC' => 'الفرنسية (سيشل)',
        'fr-SN' => 'الفرنسية (السنغال)',
        'fr-SY' => 'الفرنسية (سوريا)',
        'fr-TD' => 'الفرنسية (تشاد)',
        'fr-TG' => 'الفرنسية (توغو)',
        'fr-TN' => 'الفرنسية (تونس)',
        'fr-VU' => 'الفرنسية (فانواتو)',
        'fr-WF' => 'الفرنسية (جزر والس وفوتونا)',
        'fr-YT' => 'الفرنسية (مايوت)',
        'fur' => 'الفريلايان',
        'fur-IT' => 'الفريلايان (إيطاليا)',
        'fy' => 'الفريزيان',
        'fy-NL' => 'الفريزيان (هولندا)',
        'ga' => 'الأيرلندية',
        'ga-IE' => 'الأيرلندية (أيرلندا)',
        'gd' => 'الغيلية الأسكتلندية',
        'gd-GB' => 'الغيلية الأسكتلندية (المملكة المتحدة)',
        'gl' => 'الجاليكية',
        'gl-ES' => 'الجاليكية (إسبانيا)',
        'gsw' => 'الألمانية السويسرية',
        'gsw-CH' => 'الألمانية السويسرية (سويسرا)',
        'gsw-FR' => 'الألمانية السويسرية (فرنسا)',
        'gsw-LI' => 'الألمانية السويسرية (ليختنشتاين)',
        'gu' => 'الغوجاراتية',
        'gu-IN' => 'الغوجاراتية (الهند)',
        'guz' => 'الغيزية',
        'guz-KE' => 'الغيزية (كينيا)',
        'gv' => 'المنكية',
        'gv-IM' => 'المنكية (جزيرة مان)',
        'ha' => 'الهوسا',
        'ha-GH' => 'الهوسا (غانا)',
        'ha-NE' => 'الهوسا (النيجر)',
        'ha-NG' => 'الهوسا (نيجيريا)',
        'haw' => 'لغة هاواي',
        'haw-US' => 'لغة هاواي (الولايات المتحدة)',
        'he' => 'العبرية',
        'he-IL' => 'العبرية (إسرائيل)',
        'hi' => 'الهندية',
        'hi-IN' => 'الهندية (الهند)',
        'hr' => 'الكرواتية',
        'hr-BA' => 'الكرواتية (البوسنة والهرسك)',
        'hr-HR' => 'الكرواتية (كرواتيا)',
        'hsb' => 'الصوربية العليا',
        'hsb-DE' => 'الصوربية العليا (ألمانيا)',
        'hu' => 'الهنغارية',
        'hu-HU' => 'الهنغارية (هنغاريا)',
        'hy' => 'الأرمنية',
        'hy-AM' => 'الأرمنية (أرمينيا)',
        'ia' => 'اللّغة الوسيطة',
        'ia-001' => 'اللّغة الوسيطة (العالم)',
        'id' => 'الإندونيسية',
        'id-ID' => 'الإندونيسية (إندونيسيا)',
        'ig' => 'الإيجبو',
        'ig-NG' => 'الإيجبو (نيجيريا)',
        'ii' => 'السيتشيون يي',
        'ii-CN' => 'السيتشيون يي (الصين)',
        'is' => 'الأيسلندية',
        'is-IS' => 'الأيسلندية (آيسلندا)',
        'it' => 'الإيطالية',
        'it-CH' => 'الإيطالية (سويسرا)',
        'it-IT' => 'الإيطالية (إيطاليا)',
        'it-SM' => 'الإيطالية (سان مارينو)',
        'it-VA' => 'الإيطالية (الفاتيكان)',
        'ja' => 'اليابانية',
        'ja-JP' => 'اليابانية (اليابان)',
        'jgo' => 'نغومبا',
        'jgo-CM' => 'نغومبا (الكاميرون)',
        'jmc' => 'الماتشامية',
        'jmc-TZ' => 'الماتشامية (تنزانيا)',
        'jv' => 'الجاوية',
        'jv-ID' => 'الجاوية (إندونيسيا)',
        'ka' => 'الجورجية',
        'ka-GE' => 'الجورجية (جورجيا)',
        'kab' => 'القبيلية',
        'kab-DZ' => 'القبيلية (الجزائر)',
        'kam' => 'الكامبا',
        'kam-KE' => 'الكامبا (كينيا)',
        'kde' => 'ماكونده',
        'kde-TZ' => 'ماكونده (تنزانيا)',
        'kea' => 'كابوفيرديانو',
        'kea-CV' => 'كابوفيرديانو (الرأس الأخضر)',
        'khq' => 'كويرا تشيني',
        'khq-ML' => 'كويرا تشيني (مالي)',
        'ki' => 'الكيكيو',
        'ki-KE' => 'الكيكيو (كينيا)',
        'kk' => 'الكازاخستانية',
        'kk-KZ' => 'الكازاخستانية (كازاخستان)',
        'kkj' => 'لغة الكاكو',
        'kkj-CM' => 'لغة الكاكو (الكاميرون)',
        'kl' => 'الكالاليست',
        'kl-GL' => 'الكالاليست (غرينلاند)',
        'kln' => 'كالينجين',
        'kln-KE' => 'كالينجين (كينيا)',
        'km' => 'الخميرية',
        'km-KH' => 'الخميرية (كمبوديا)',
        'kn' => 'الكانادا',
        'kn-IN' => 'الكانادا (الهند)',
        'ko' => 'الكورية',
        'ko-KP' => 'الكورية (كوريا الشمالية)',
        'ko-KR' => 'الكورية (كوريا الجنوبية)',
        'kok' => 'الكونكانية',
        'kok-IN' => 'الكونكانية (الهند)',
        'ks' => 'الكشميرية',
        'ks-IN' => 'الكشميرية (الهند)',
        'ksb' => 'شامبالا',
        'ksb-TZ' => 'شامبالا (تنزانيا)',
        'ksf' => 'لغة البافيا',
        'ksf-CM' => 'لغة البافيا (الكاميرون)',
        'ksh' => 'لغة الكولونيان',
        'ksh-DE' => 'لغة الكولونيان (ألمانيا)',
        'ku' => 'الكردية',
        'ku-TR' => 'الكردية (تركيا)',
        'kw' => 'الكورنية',
        'kw-GB' => 'الكورنية (المملكة المتحدة)',
        'ky' => 'القيرغيزية',
        'ky-KG' => 'القيرغيزية (قيرغيزستان)',
        'lag' => 'لانجي',
        'lag-TZ' => 'لانجي (تنزانيا)',
        'lb' => 'اللكسمبورغية',
        'lb-LU' => 'اللكسمبورغية (لوكسمبورغ)',
        'lg' => 'الغاندا',
        'lg-UG' => 'الغاندا (أوغندا)',
        'lkt' => 'لاكوتا',
        'lkt-US' => 'لاكوتا (الولايات المتحدة)',
        'ln' => 'اللينجالا',
        'ln-AO' => 'اللينجالا (أنغولا)',
        'ln-CD' => 'اللينجالا (الكونغو - كينشاسا)',
        'ln-CF' => 'اللينجالا (جمهورية أفريقيا الوسطى)',
        'ln-CG' => 'اللينجالا (الكونغو - برازافيل)',
        'lo' => 'اللاوية',
        'lo-LA' => 'اللاوية (لاوس)',
        'lrc' => 'اللرية الشمالية',
        'lrc-IQ' => 'اللرية الشمالية (العراق)',
        'lrc-IR' => 'اللرية الشمالية (إيران)',
        'lt' => 'الليتوانية',
        'lt-LT' => 'الليتوانية (ليتوانيا)',
        'lu' => 'اللوبا كاتانغا',
        'lu-CD' => 'اللوبا كاتانغا (الكونغو - كينشاسا)',
        'luo' => 'اللو',
        'luo-KE' => 'اللو (كينيا)',
        'luy' => 'لغة اللويا',
        'luy-KE' => 'لغة اللويا (كينيا)',
        'lv' => 'اللاتفية',
        'lv-LV' => 'اللاتفية (لاتفيا)',
        'mas' => 'الماساي',
        'mas-KE' => 'الماساي (كينيا)',
        'mas-TZ' => 'الماساي (تنزانيا)',
        'mer' => 'الميرو',
        'mer-KE' => 'الميرو (كينيا)',
        'mfe' => 'المورسيانية',
        'mfe-MU' => 'المورسيانية (موريشيوس)',
        'mg' => 'الملغاشي',
        'mg-MG' => 'الملغاشي (مدغشقر)',
        'mgh' => 'ماخاوا-ميتو',
        'mgh-MZ' => 'ماخاوا-ميتو (موزمبيق)',
        'mgo' => 'ميتا',
        'mgo-CM' => 'ميتا (الكاميرون)',
        'mi' => 'الماورية',
        'mi-NZ' => 'الماورية (نيوزيلندا)',
        'mk' => 'المقدونية',
        'mk-MK' => 'المقدونية (مقدونيا)',
        'ml' => 'المالايالامية',
        'ml-IN' => 'المالايالامية (الهند)',
        'mn' => 'المنغولية',
        'mn-MN' => 'المنغولية (منغوليا)',
        'mr' => 'الماراثية',
        'mr-IN' => 'الماراثية (الهند)',
        'ms' => 'الماليزية',
        'ms-BN' => 'الماليزية (بروناي)',
        'ms-MY' => 'الماليزية (ماليزيا)',
        'ms-SG' => 'الماليزية (سنغافورة)',
        'mt' => 'المالطية',
        'mt-MT' => 'المالطية (مالطا)',
        'mua' => 'مندنج',
        'mua-CM' => 'مندنج (الكاميرون)',
        'my' => 'البورمية',
        'my-MM' => 'البورمية (ميانمار [بورما])',
        'mzn' => 'المازندرانية',
        'mzn-IR' => 'المازندرانية (إيران)',
        'naq' => 'لغة الناما',
        'naq-NA' => 'لغة الناما (ناميبيا)',
        'nb' => 'النرويجية بوكمال',
        'nb-NO' => 'النرويجية بوكمال (النرويج)',
        'nb-SJ' => 'النرويجية بوكمال (سفالبارد وجان ماين)',
        'nd' => 'النديبيل الشمالية',
        'nd-ZW' => 'النديبيل الشمالية (زيمبابوي)',
        'nds' => 'الألمانية السفلى',
        'nds-DE' => 'الألمانية السفلى (ألمانيا)',
        'nds-NL' => 'الألمانية السفلى (هولندا)',
        'ne' => 'النيبالية',
        'ne-IN' => 'النيبالية (الهند)',
        'ne-NP' => 'النيبالية (نيبال)',
        'nl' => 'الهولندية',
        'nl-AW' => 'الهولندية (أروبا)',
        'nl-BE' => 'الهولندية (بلجيكا)',
        'nl-BQ' => 'الهولندية (هولندا الكاريبية)',
        'nl-CW' => 'الهولندية (كوراساو)',
        'nl-NL' => 'الهولندية (هولندا)',
        'nl-SR' => 'الهولندية (سورينام)',
        'nl-SX' => 'الهولندية (سانت مارتن)',
        'nmg' => 'كواسيو',
        'nmg-CM' => 'كواسيو (الكاميرون)',
        'nn' => 'النرويجية نينورسك',
        'nn-NO' => 'النرويجية نينورسك (النرويج)',
        'nnh' => 'لغة النجيمبون',
        'nnh-CM' => 'لغة النجيمبون (الكاميرون)',
        'nus' => 'النوير',
        'nus-SS' => 'النوير (جنوب السودان)',
        'nyn' => 'النيانكول',
        'nyn-UG' => 'النيانكول (أوغندا)',
        'om' => 'الأورومية',
        'om-ET' => 'الأورومية (إثيوبيا)',
        'om-KE' => 'الأورومية (كينيا)',
        'or' => 'الأورية',
        'or-IN' => 'الأورية (الهند)',
        'os' => 'الأوسيتيك',
        'os-GE' => 'الأوسيتيك (جورجيا)',
        'os-RU' => 'الأوسيتيك (روسيا)',
        'pa' => 'البنجابية',
        'pa-Arab' => 'البنجابية (العربية)',
        'pa-Arab-PK' => 'البنجابية (العربية، باكستان)',
        'pa-Guru' => 'البنجابية (الجرمخي)',
        'pa-Guru-IN' => 'البنجابية (الجرمخي، الهند)',
        'pl' => 'البولندية',
        'pl-PL' => 'البولندية (بولندا)',
        'ps' => 'البشتو',
        'ps-AF' => 'البشتو (أفغانستان)',
        'ps-PK' => 'البشتو (باكستان)',
        'pt' => 'البرتغالية',
        'pt-AO' => 'البرتغالية (أنغولا)',
        'pt-BR' => 'البرتغالية (البرازيل)',
        'pt-CH' => 'البرتغالية (سويسرا)',
        'pt-CV' => 'البرتغالية (الرأس الأخضر)',
        'pt-GQ' => 'البرتغالية (غينيا الاستوائية)',
        'pt-GW' => 'البرتغالية (غينيا بيساو)',
        'pt-LU' => 'البرتغالية (لوكسمبورغ)',
        'pt-MO' => 'البرتغالية (مكاو الصينية [منطقة إدارية خاصة])',
        'pt-MZ' => 'البرتغالية (موزمبيق)',
        'pt-PT' => 'البرتغالية (البرتغال)',
        'pt-ST' => 'البرتغالية (ساو تومي وبرينسيبي)',
        'pt-TL' => 'البرتغالية (تيمور - ليشتي)',
        'qu' => 'الكويتشوا',
        'qu-BO' => 'الكويتشوا (بوليفيا)',
        'qu-EC' => 'الكويتشوا (الإكوادور)',
        'qu-PE' => 'الكويتشوا (بيرو)',
        'rm' => 'الرومانشية',
        'rm-CH' => 'الرومانشية (سويسرا)',
        'rn' => 'الرندي',
        'rn-BI' => 'الرندي (بوروندي)',
        'ro' => 'الرومانية',
        'ro-MD' => 'الرومانية (مولدوفا)',
        'ro-RO' => 'الرومانية (رومانيا)',
        'rof' => 'الرومبو',
        'rof-TZ' => 'الرومبو (تنزانيا)',
        'ru' => 'الروسية',
        'ru-BY' => 'الروسية (بيلاروس)',
        'ru-KG' => 'الروسية (قيرغيزستان)',
        'ru-KZ' => 'الروسية (كازاخستان)',
        'ru-MD' => 'الروسية (مولدوفا)',
        'ru-RU' => 'الروسية (روسيا)',
        'ru-UA' => 'الروسية (أوكرانيا)',
        'rw' => 'الكينيارواندا',
        'rw-RW' => 'الكينيارواندا (رواندا)',
        'rwk' => 'الروا',
        'rwk-TZ' => 'الروا (تنزانيا)',
        'sah' => 'الساخيّة',
        'sah-RU' => 'الساخيّة (روسيا)',
        'saq' => 'سامبورو',
        'saq-KE' => 'سامبورو (كينيا)',
        'sbp' => 'سانغو',
        'sbp-TZ' => 'سانغو (تنزانيا)',
        'sd' => 'السندية',
        'sd-PK' => 'السندية (باكستان)',
        'se' => 'سامي الشمالية',
        'se-FI' => 'سامي الشمالية (فنلندا)',
        'se-NO' => 'سامي الشمالية (النرويج)',
        'se-SE' => 'سامي الشمالية (السويد)',
        'seh' => 'سينا',
        'seh-MZ' => 'سينا (موزمبيق)',
        'ses' => 'كويرابورو سيني',
        'ses-ML' => 'كويرابورو سيني (مالي)',
        'sg' => 'السانجو',
        'sg-CF' => 'السانجو (جمهورية أفريقيا الوسطى)',
        'shi' => 'تشلحيت',
        'shi-Latn' => 'تشلحيت (اللاتينية)',
        'shi-Latn-MA' => 'تشلحيت (اللاتينية، المغرب)',
        'shi-Tfng' => 'تشلحيت (التيفيناغ)',
        'shi-Tfng-MA' => 'تشلحيت (التيفيناغ، المغرب)',
        'si' => 'السنهالية',
        'si-LK' => 'السنهالية (سريلانكا)',
        'sk' => 'السلوفاكية',
        'sk-SK' => 'السلوفاكية (سلوفاكيا)',
        'sl' => 'السلوفانية',
        'sl-SI' => 'السلوفانية (سلوفينيا)',
        'smn' => 'الإيناري سامي',
        'smn-FI' => 'الإيناري سامي (فنلندا)',
        'sn' => 'الشونا',
        'sn-ZW' => 'الشونا (زيمبابوي)',
        'so' => 'الصومالية',
        'so-DJ' => 'الصومالية (جيبوتي)',
        'so-ET' => 'الصومالية (إثيوبيا)',
        'so-KE' => 'الصومالية (كينيا)',
        'so-SO' => 'الصومالية (الصومال)',
        'sq' => 'الألبانية',
        'sq-AL' => 'الألبانية (ألبانيا)',
        'sq-MK' => 'الألبانية (مقدونيا)',
        'sq-XK' => 'الألبانية (كوسوفو)',
        'sr' => 'الصربية',
        'sr-Cyrl' => 'الصربية (السيريلية)',
        'sr-Cyrl-BA' => 'الصربية (السيريلية، البوسنة والهرسك)',
        'sr-Cyrl-ME' => 'الصربية (السيريلية، الجبل الأسود)',
        'sr-Cyrl-RS' => 'الصربية (السيريلية، صربيا)',
        'sr-Cyrl-XK' => 'الصربية (السيريلية، كوسوفو)',
        'sr-Latn' => 'الصربية (اللاتينية)',
        'sr-Latn-BA' => 'الصربية (اللاتينية، البوسنة والهرسك)',
        'sr-Latn-ME' => 'الصربية (اللاتينية، الجبل الأسود)',
        'sr-Latn-RS' => 'الصربية (اللاتينية، صربيا)',
        'sr-Latn-XK' => 'الصربية (اللاتينية، كوسوفو)',
        'sv' => 'السويدية',
        'sv-AX' => 'السويدية (جزر آلاند)',
        'sv-FI' => 'السويدية (فنلندا)',
        'sv-SE' => 'السويدية (السويد)',
        'sw' => 'السواحلية',
        'sw-CD' => 'السواحلية (الكونغو - كينشاسا)',
        'sw-KE' => 'السواحلية (كينيا)',
        'sw-TZ' => 'السواحلية (تنزانيا)',
        'sw-UG' => 'السواحلية (أوغندا)',
        'ta' => 'التاميلية',
        'ta-IN' => 'التاميلية (الهند)',
        'ta-LK' => 'التاميلية (سريلانكا)',
        'ta-MY' => 'التاميلية (ماليزيا)',
        'ta-SG' => 'التاميلية (سنغافورة)',
        'te' => 'التيلوغوية',
        'te-IN' => 'التيلوغوية (الهند)',
        'teo' => 'تيسو',
        'teo-KE' => 'تيسو (كينيا)',
        'teo-UG' => 'تيسو (أوغندا)',
        'tg' => 'الطاجيكية',
        'tg-TJ' => 'الطاجيكية (طاجيكستان)',
        'th' => 'التايلاندية',
        'th-TH' => 'التايلاندية (تايلاند)',
        'ti' => 'التغرينية',
        'ti-ER' => 'التغرينية (إريتريا)',
        'ti-ET' => 'التغرينية (إثيوبيا)',
        'tk' => 'التركمانية',
        'tk-TM' => 'التركمانية (تركمانستان)',
        'to' => 'التونغية',
        'to-TO' => 'التونغية (تونغا)',
        'tr' => 'التركية',
        'tr-CY' => 'التركية (قبرص)',
        'tr-TR' => 'التركية (تركيا)',
        'tt' => 'التترية',
        'tt-RU' => 'التترية (روسيا)',
        'twq' => 'تاساواق',
        'twq-NE' => 'تاساواق (النيجر)',
        'tzm' => 'الأمازيغية وسط الأطلس',
        'tzm-MA' => 'الأمازيغية وسط الأطلس (المغرب)',
        'ug' => 'الأويغورية',
        'ug-CN' => 'الأويغورية (الصين)',
        'uk' => 'الأوكرانية',
        'uk-UA' => 'الأوكرانية (أوكرانيا)',
        'ur' => 'الأوردية',
        'ur-IN' => 'الأوردية (الهند)',
        'ur-PK' => 'الأوردية (باكستان)',
        'uz' => 'الأوزبكية',
        'uz-Arab' => 'الأوزبكية (العربية)',
        'uz-Arab-AF' => 'الأوزبكية (العربية، أفغانستان)',
        'uz-Cyrl' => 'الأوزبكية (السيريلية)',
        'uz-Cyrl-UZ' => 'الأوزبكية (السيريلية، أوزبكستان)',
        'uz-Latn' => 'الأوزبكية (اللاتينية)',
        'uz-Latn-UZ' => 'الأوزبكية (اللاتينية، أوزبكستان)',
        'vai' => 'الفاي',
        'vai-Latn' => 'الفاي (اللاتينية)',
        'vai-Latn-LR' => 'الفاي (اللاتينية، ليبيريا)',
        'vai-Vaii' => 'الفاي (الفاي)',
        'vai-Vaii-LR' => 'الفاي (الفاي، ليبيريا)',
        'vi' => 'الفيتنامية',
        'vi-VN' => 'الفيتنامية (فيتنام)',
        'vun' => 'الفونجو',
        'vun-TZ' => 'الفونجو (تنزانيا)',
        'wae' => 'الوالسر',
        'wae-CH' => 'الوالسر (سويسرا)',
        'wo' => 'الولوفية',
        'wo-SN' => 'الولوفية (السنغال)',
        'xh' => 'الخوسا',
        'xh-ZA' => 'الخوسا (جنوب أفريقيا)',
        'xog' => 'السوغا',
        'xog-UG' => 'السوغا (أوغندا)',
        'yav' => 'يانجبن',
        'yav-CM' => 'يانجبن (الكاميرون)',
        'yi' => 'اليديشية',
        'yi-001' => 'اليديشية (العالم)',
        'yo' => 'اليوروبا',
        'yo-BJ' => 'اليوروبا (بنين)',
        'yo-NG' => 'اليوروبا (نيجيريا)',
        'yue' => 'الكَنْتُونية',
        'yue-Hans' => 'الكَنْتُونية (المبسطة)',
        'yue-Hans-CN' => 'الكَنْتُونية (المبسطة، الصين)',
        'yue-Hant' => 'الكَنْتُونية (التقليدية)',
        'yue-Hant-HK' => 'الكَنْتُونية (التقليدية، هونغ كونغ الصينية [منطقة إدارية خاصة])',
        'zgh' => 'التمازيغية المغربية القياسية',
        'zgh-MA' => 'التمازيغية المغربية القياسية (المغرب)',
        'zh' => 'الصينية',
        'zh-Hans' => 'الصينية (المبسطة)',
        'zh-Hans-CN' => 'الصينية (المبسطة، الصين)',
        'zh-Hans-HK' => 'الصينية (المبسطة، هونغ كونغ الصينية [منطقة إدارية خاصة])',
        'zh-Hans-MO' => 'الصينية (المبسطة، مكاو الصينية [منطقة إدارية خاصة])',
        'zh-Hans-SG' => 'الصينية (المبسطة، سنغافورة)',
        'zh-Hant' => 'الصينية (التقليدية)',
        'zh-Hant-HK' => 'الصينية (التقليدية، هونغ كونغ الصينية [منطقة إدارية خاصة])',
        'zh-Hant-MO' => 'الصينية (التقليدية، مكاو الصينية [منطقة إدارية خاصة])',
        'zh-Hant-TW' => 'الصينية (التقليدية، تايوان)',
        'zu' => 'الزولو',
        'zu-ZA' => 'الزولو (جنوب أفريقيا)',
    ],
];
