<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'dd.MM.y',
            'time' => 'HH:mm',
            'datetime' => 'dd.MM.y, HH:mm',
        ],
        'medium' => [
            'date' => 'd MMM y \'г\'.',
            'time' => 'HH:mm:ss',
            'datetime' => 'd MMM y \'г\'., HH:mm:ss',
        ],
        'long' => [
            'date' => 'd MMMM y \'г\'.',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd MMMM y \'г\'., HH:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE, d MMMM y \'г\'.',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'EEEE, d MMMM y \'г\'., HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0 %',
        'scientific' => '#E0',
    ],
    'amName' => 'AM',
    'pmName' => 'PM',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => 'XXX',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => ' ',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'не число',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => ' ',
    ],
    'currencySymbols' => [
        'AUD' => 'A$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => '¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA ',
        'XCD' => 'EC$',
        'XOF' => 'CFA ',
        'XPF' => 'CFPF ',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'Я',
            'Ф',
            'М',
            'А',
            'М',
            'И',
            'И',
            'А',
            'С',
            'О',
            'Н',
            'Д',
        ],
        'medium' => [
            'янв.',
            'февр.',
            'март',
            'апр.',
            'май',
            'июнь',
            'июль',
            'авг.',
            'сент.',
            'окт.',
            'нояб.',
            'дек.',
        ],
        'full' => [
            'январь',
            'февраль',
            'март',
            'апрель',
            'май',
            'июнь',
            'июль',
            'август',
            'сентябрь',
            'октябрь',
            'ноябрь',
            'декабрь',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'Я',
            'Ф',
            'М',
            'А',
            'М',
            'И',
            'И',
            'А',
            'С',
            'О',
            'Н',
            'Д',
        ],
        'medium' => [
            'янв.',
            'февр.',
            'мар.',
            'апр.',
            'мая',
            'июн.',
            'июл.',
            'авг.',
            'сент.',
            'окт.',
            'нояб.',
            'дек.',
        ],
        'full' => [
            'января',
            'февраля',
            'марта',
            'апреля',
            'мая',
            'июня',
            'июля',
            'августа',
            'сентября',
            'октября',
            'ноября',
            'декабря',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'В',
            'П',
            'В',
            'С',
            'Ч',
            'П',
            'С',
        ],
        'short' => [
            'вс',
            'пн',
            'вт',
            'ср',
            'чт',
            'пт',
            'сб',
        ],
        'medium' => [
            'вс',
            'пн',
            'вт',
            'ср',
            'чт',
            'пт',
            'сб',
        ],
        'full' => [
            'воскресенье',
            'понедельник',
            'вторник',
            'среда',
            'четверг',
            'пятница',
            'суббота',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'вс',
            'пн',
            'вт',
            'ср',
            'чт',
            'пт',
            'сб',
        ],
        'short' => [
            'вс',
            'пн',
            'вт',
            'ср',
            'чт',
            'пт',
            'сб',
        ],
        'medium' => [
            'вс',
            'пн',
            'вт',
            'ср',
            'чт',
            'пт',
            'сб',
        ],
        'full' => [
            'воскресенье',
            'понедельник',
            'вторник',
            'среда',
            'четверг',
            'пятница',
            'суббота',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'африкаанс',
        'af-NA' => 'африкаанс (Намибия)',
        'af-ZA' => 'африкаанс (Южно-Африканская Республика)',
        'agq' => 'агем',
        'agq-CM' => 'агем (Камерун)',
        'ak' => 'акан',
        'ak-GH' => 'акан (Гана)',
        'am' => 'амхарский',
        'am-ET' => 'амхарский (Эфиопия)',
        'ar' => 'арабский',
        'ar-001' => 'арабский (весь мир)',
        'ar-AE' => 'арабский (ОАЭ)',
        'ar-BH' => 'арабский (Бахрейн)',
        'ar-DJ' => 'арабский (Джибути)',
        'ar-DZ' => 'арабский (Алжир)',
        'ar-EG' => 'арабский (Египет)',
        'ar-EH' => 'арабский (Западная Сахара)',
        'ar-ER' => 'арабский (Эритрея)',
        'ar-IL' => 'арабский (Израиль)',
        'ar-IQ' => 'арабский (Ирак)',
        'ar-JO' => 'арабский (Иордания)',
        'ar-KM' => 'арабский (Коморы)',
        'ar-KW' => 'арабский (Кувейт)',
        'ar-LB' => 'арабский (Ливан)',
        'ar-LY' => 'арабский (Ливия)',
        'ar-MA' => 'арабский (Марокко)',
        'ar-MR' => 'арабский (Мавритания)',
        'ar-OM' => 'арабский (Оман)',
        'ar-PS' => 'арабский (Палестинские территории)',
        'ar-QA' => 'арабский (Катар)',
        'ar-SA' => 'арабский (Саудовская Аравия)',
        'ar-SD' => 'арабский (Судан)',
        'ar-SO' => 'арабский (Сомали)',
        'ar-SS' => 'арабский (Южный Судан)',
        'ar-SY' => 'арабский (Сирия)',
        'ar-TD' => 'арабский (Чад)',
        'ar-TN' => 'арабский (Тунис)',
        'ar-YE' => 'арабский (Йемен)',
        'as' => 'ассамский',
        'as-IN' => 'ассамский (Индия)',
        'asa' => 'асу',
        'asa-TZ' => 'асу (Танзания)',
        'ast' => 'астурийский',
        'ast-ES' => 'астурийский (Испания)',
        'az' => 'азербайджанский',
        'az-Cyrl' => 'азербайджанский (кириллица)',
        'az-Cyrl-AZ' => 'азербайджанский (кириллица, Азербайджан)',
        'az-Latn' => 'азербайджанский (латиница)',
        'az-Latn-AZ' => 'азербайджанский (латиница, Азербайджан)',
        'bas' => 'баса',
        'bas-CM' => 'баса (Камерун)',
        'be' => 'белорусский',
        'be-BY' => 'белорусский (Беларусь)',
        'bem' => 'бемба',
        'bem-ZM' => 'бемба (Замбия)',
        'bez' => 'бена',
        'bez-TZ' => 'бена (Танзания)',
        'bg' => 'болгарский',
        'bg-BG' => 'болгарский (Болгария)',
        'bm' => 'бамбара',
        'bm-ML' => 'бамбара (Мали)',
        'bn' => 'бенгальский',
        'bn-BD' => 'бенгальский (Бангладеш)',
        'bn-IN' => 'бенгальский (Индия)',
        'bo' => 'тибетский',
        'bo-CN' => 'тибетский (Китай)',
        'bo-IN' => 'тибетский (Индия)',
        'br' => 'бретонский',
        'br-FR' => 'бретонский (Франция)',
        'brx' => 'бодо',
        'brx-IN' => 'бодо (Индия)',
        'bs' => 'боснийский',
        'bs-Cyrl' => 'боснийский (кириллица)',
        'bs-Cyrl-BA' => 'боснийский (кириллица, Босния и Герцеговина)',
        'bs-Latn' => 'боснийский (латиница)',
        'bs-Latn-BA' => 'боснийский (латиница, Босния и Герцеговина)',
        'ca' => 'каталанский',
        'ca-AD' => 'каталанский (Андорра)',
        'ca-ES' => 'каталанский (Испания)',
        'ca-FR' => 'каталанский (Франция)',
        'ca-IT' => 'каталанский (Италия)',
        'ccp' => 'чакма',
        'ccp-BD' => 'чакма (Бангладеш)',
        'ccp-IN' => 'чакма (Индия)',
        'ce' => 'чеченский',
        'ce-RU' => 'чеченский (Россия)',
        'ceb' => 'себуано',
        'ceb-PH' => 'себуано (Филиппины)',
        'cgg' => 'кига',
        'cgg-UG' => 'кига (Уганда)',
        'chr' => 'чероки',
        'chr-US' => 'чероки (Соединенные Штаты)',
        'ckb' => 'сорани',
        'ckb-IQ' => 'сорани (Ирак)',
        'ckb-IR' => 'сорани (Иран)',
        'cs' => 'чешский',
        'cs-CZ' => 'чешский (Чехия)',
        'cy' => 'валлийский',
        'cy-GB' => 'валлийский (Великобритания)',
        'da' => 'датский',
        'da-DK' => 'датский (Дания)',
        'da-GL' => 'датский (Гренландия)',
        'dav' => 'таита',
        'dav-KE' => 'таита (Кения)',
        'de' => 'немецкий',
        'de-AT' => 'немецкий (Австрия)',
        'de-BE' => 'немецкий (Бельгия)',
        'de-CH' => 'немецкий (Швейцария)',
        'de-DE' => 'немецкий (Германия)',
        'de-IT' => 'немецкий (Италия)',
        'de-LI' => 'немецкий (Лихтенштейн)',
        'de-LU' => 'немецкий (Люксембург)',
        'dje' => 'джерма',
        'dje-NE' => 'джерма (Нигер)',
        'dsb' => 'нижнелужицкий',
        'dsb-DE' => 'нижнелужицкий (Германия)',
        'dua' => 'дуала',
        'dua-CM' => 'дуала (Камерун)',
        'dyo' => 'диола-фоньи',
        'dyo-SN' => 'диола-фоньи (Сенегал)',
        'dz' => 'дзонг-кэ',
        'dz-BT' => 'дзонг-кэ (Бутан)',
        'ebu' => 'эмбу',
        'ebu-KE' => 'эмбу (Кения)',
        'ee' => 'эве',
        'ee-GH' => 'эве (Гана)',
        'ee-TG' => 'эве (Того)',
        'el' => 'греческий',
        'el-CY' => 'греческий (Кипр)',
        'el-GR' => 'греческий (Греция)',
        'en' => 'английский',
        'en-001' => 'английский (весь мир)',
        'en-150' => 'английский (Европа)',
        'en-AE' => 'английский (ОАЭ)',
        'en-AG' => 'английский (Антигуа и Барбуда)',
        'en-AI' => 'английский (Ангилья)',
        'en-AS' => 'английский (Американское Самоа)',
        'en-AT' => 'английский (Австрия)',
        'en-AU' => 'английский (Австралия)',
        'en-BB' => 'английский (Барбадос)',
        'en-BE' => 'английский (Бельгия)',
        'en-BI' => 'английский (Бурунди)',
        'en-BM' => 'английский (Бермудские о-ва)',
        'en-BS' => 'английский (Багамы)',
        'en-BW' => 'английский (Ботсвана)',
        'en-BZ' => 'английский (Белиз)',
        'en-CA' => 'английский (Канада)',
        'en-CC' => 'английский (Кокосовые о-ва)',
        'en-CH' => 'английский (Швейцария)',
        'en-CK' => 'английский (Острова Кука)',
        'en-CM' => 'английский (Камерун)',
        'en-CX' => 'английский (о-в Рождества)',
        'en-CY' => 'английский (Кипр)',
        'en-DE' => 'английский (Германия)',
        'en-DG' => 'английский (Диего-Гарсия)',
        'en-DK' => 'английский (Дания)',
        'en-DM' => 'английский (Доминика)',
        'en-ER' => 'английский (Эритрея)',
        'en-FI' => 'английский (Финляндия)',
        'en-FJ' => 'английский (Фиджи)',
        'en-FK' => 'английский (Фолклендские о-ва)',
        'en-FM' => 'английский (Федеративные Штаты Микронезии)',
        'en-GB' => 'английский (Великобритания)',
        'en-GD' => 'английский (Гренада)',
        'en-GG' => 'английский (Гернси)',
        'en-GH' => 'английский (Гана)',
        'en-GI' => 'английский (Гибралтар)',
        'en-GM' => 'английский (Гамбия)',
        'en-GU' => 'английский (Гуам)',
        'en-GY' => 'английский (Гайана)',
        'en-HK' => 'английский (Гонконг [САР])',
        'en-IE' => 'английский (Ирландия)',
        'en-IL' => 'английский (Израиль)',
        'en-IM' => 'английский (о-в Мэн)',
        'en-IN' => 'английский (Индия)',
        'en-IO' => 'английский (Британская территория в Индийском океане)',
        'en-JE' => 'английский (Джерси)',
        'en-JM' => 'английский (Ямайка)',
        'en-KE' => 'английский (Кения)',
        'en-KI' => 'английский (Кирибати)',
        'en-KN' => 'английский (Сент-Китс и Невис)',
        'en-KY' => 'английский (Острова Кайман)',
        'en-LC' => 'английский (Сент-Люсия)',
        'en-LR' => 'английский (Либерия)',
        'en-LS' => 'английский (Лесото)',
        'en-MG' => 'английский (Мадагаскар)',
        'en-MH' => 'английский (Маршалловы Острова)',
        'en-MO' => 'английский (Макао [САР])',
        'en-MP' => 'английский (Северные Марианские о-ва)',
        'en-MS' => 'английский (Монтсеррат)',
        'en-MT' => 'английский (Мальта)',
        'en-MU' => 'английский (Маврикий)',
        'en-MW' => 'английский (Малави)',
        'en-MY' => 'английский (Малайзия)',
        'en-NA' => 'английский (Намибия)',
        'en-NF' => 'английский (о-в Норфолк)',
        'en-NG' => 'английский (Нигерия)',
        'en-NL' => 'английский (Нидерланды)',
        'en-NR' => 'английский (Науру)',
        'en-NU' => 'английский (Ниуэ)',
        'en-NZ' => 'английский (Новая Зеландия)',
        'en-PG' => 'английский (Папуа — Новая Гвинея)',
        'en-PH' => 'английский (Филиппины)',
        'en-PK' => 'английский (Пакистан)',
        'en-PN' => 'английский (о-ва Питкэрн)',
        'en-PR' => 'английский (Пуэрто-Рико)',
        'en-PW' => 'английский (Палау)',
        'en-RW' => 'английский (Руанда)',
        'en-SB' => 'английский (Соломоновы Острова)',
        'en-SC' => 'английский (Сейшельские Острова)',
        'en-SD' => 'английский (Судан)',
        'en-SE' => 'английский (Швеция)',
        'en-SG' => 'английский (Сингапур)',
        'en-SH' => 'английский (о-в Св. Елены)',
        'en-SI' => 'английский (Словения)',
        'en-SL' => 'английский (Сьерра-Леоне)',
        'en-SS' => 'английский (Южный Судан)',
        'en-SX' => 'английский (Синт-Мартен)',
        'en-SZ' => 'английский (Эсватини)',
        'en-TC' => 'английский (о-ва Тёркс и Кайкос)',
        'en-TK' => 'английский (Токелау)',
        'en-TO' => 'английский (Тонга)',
        'en-TT' => 'английский (Тринидад и Тобаго)',
        'en-TV' => 'английский (Тувалу)',
        'en-TZ' => 'английский (Танзания)',
        'en-UG' => 'английский (Уганда)',
        'en-UM' => 'английский (Внешние малые о-ва [США])',
        'en-US' => 'английский (Соединенные Штаты)',
        'en-US-POSIX' => 'английский (Соединенные Штаты, Компьютерный)',
        'en-VC' => 'английский (Сент-Винсент и Гренадины)',
        'en-VG' => 'английский (Виргинские о-ва [Великобритания])',
        'en-VI' => 'английский (Виргинские о-ва [США])',
        'en-VU' => 'английский (Вануату)',
        'en-WS' => 'английский (Самоа)',
        'en-ZA' => 'английский (Южно-Африканская Республика)',
        'en-ZM' => 'английский (Замбия)',
        'en-ZW' => 'английский (Зимбабве)',
        'eo' => 'эсперанто',
        'eo-001' => 'эсперанто (весь мир)',
        'es' => 'испанский',
        'es-419' => 'испанский (Латинская Америка)',
        'es-AR' => 'испанский (Аргентина)',
        'es-BO' => 'испанский (Боливия)',
        'es-BR' => 'испанский (Бразилия)',
        'es-BZ' => 'испанский (Белиз)',
        'es-CL' => 'испанский (Чили)',
        'es-CO' => 'испанский (Колумбия)',
        'es-CR' => 'испанский (Коста-Рика)',
        'es-CU' => 'испанский (Куба)',
        'es-DO' => 'испанский (Доминиканская Республика)',
        'es-EA' => 'испанский (Сеута и Мелилья)',
        'es-EC' => 'испанский (Эквадор)',
        'es-ES' => 'испанский (Испания)',
        'es-GQ' => 'испанский (Экваториальная Гвинея)',
        'es-GT' => 'испанский (Гватемала)',
        'es-HN' => 'испанский (Гондурас)',
        'es-IC' => 'испанский (Канарские о-ва)',
        'es-MX' => 'испанский (Мексика)',
        'es-NI' => 'испанский (Никарагуа)',
        'es-PA' => 'испанский (Панама)',
        'es-PE' => 'испанский (Перу)',
        'es-PH' => 'испанский (Филиппины)',
        'es-PR' => 'испанский (Пуэрто-Рико)',
        'es-PY' => 'испанский (Парагвай)',
        'es-SV' => 'испанский (Сальвадор)',
        'es-US' => 'испанский (Соединенные Штаты)',
        'es-UY' => 'испанский (Уругвай)',
        'es-VE' => 'испанский (Венесуэла)',
        'et' => 'эстонский',
        'et-EE' => 'эстонский (Эстония)',
        'eu' => 'баскский',
        'eu-ES' => 'баскский (Испания)',
        'ewo' => 'эвондо',
        'ewo-CM' => 'эвондо (Камерун)',
        'fa' => 'персидский',
        'fa-AF' => 'персидский (Афганистан)',
        'fa-IR' => 'персидский (Иран)',
        'ff' => 'фулах',
        'ff-Latn' => 'фулах (латиница)',
        'ff-Latn-BF' => 'фулах (латиница, Буркина-Фасо)',
        'ff-Latn-CM' => 'фулах (латиница, Камерун)',
        'ff-Latn-GH' => 'фулах (латиница, Гана)',
        'ff-Latn-GM' => 'фулах (латиница, Гамбия)',
        'ff-Latn-GN' => 'фулах (латиница, Гвинея)',
        'ff-Latn-GW' => 'фулах (латиница, Гвинея-Бисау)',
        'ff-Latn-LR' => 'фулах (латиница, Либерия)',
        'ff-Latn-MR' => 'фулах (латиница, Мавритания)',
        'ff-Latn-NE' => 'фулах (латиница, Нигер)',
        'ff-Latn-NG' => 'фулах (латиница, Нигерия)',
        'ff-Latn-SL' => 'фулах (латиница, Сьерра-Леоне)',
        'ff-Latn-SN' => 'фулах (латиница, Сенегал)',
        'fi' => 'финский',
        'fi-FI' => 'финский (Финляндия)',
        'fil' => 'филиппинский',
        'fil-PH' => 'филиппинский (Филиппины)',
        'fo' => 'фарерский',
        'fo-DK' => 'фарерский (Дания)',
        'fo-FO' => 'фарерский (Фарерские о-ва)',
        'fr' => 'французский',
        'fr-BE' => 'французский (Бельгия)',
        'fr-BF' => 'французский (Буркина-Фасо)',
        'fr-BI' => 'французский (Бурунди)',
        'fr-BJ' => 'французский (Бенин)',
        'fr-BL' => 'французский (Сен-Бартелеми)',
        'fr-CA' => 'французский (Канада)',
        'fr-CD' => 'французский (Конго - Киншаса)',
        'fr-CF' => 'французский (Центрально-Африканская Республика)',
        'fr-CG' => 'французский (Конго - Браззавиль)',
        'fr-CH' => 'французский (Швейцария)',
        'fr-CI' => 'французский (Кот-д’Ивуар)',
        'fr-CM' => 'французский (Камерун)',
        'fr-DJ' => 'французский (Джибути)',
        'fr-DZ' => 'французский (Алжир)',
        'fr-FR' => 'французский (Франция)',
        'fr-GA' => 'французский (Габон)',
        'fr-GF' => 'французский (Французская Гвиана)',
        'fr-GN' => 'французский (Гвинея)',
        'fr-GP' => 'французский (Гваделупа)',
        'fr-GQ' => 'французский (Экваториальная Гвинея)',
        'fr-HT' => 'французский (Гаити)',
        'fr-KM' => 'французский (Коморы)',
        'fr-LU' => 'французский (Люксембург)',
        'fr-MA' => 'французский (Марокко)',
        'fr-MC' => 'французский (Монако)',
        'fr-MF' => 'французский (Сен-Мартен)',
        'fr-MG' => 'французский (Мадагаскар)',
        'fr-ML' => 'французский (Мали)',
        'fr-MQ' => 'французский (Мартиника)',
        'fr-MR' => 'французский (Мавритания)',
        'fr-MU' => 'французский (Маврикий)',
        'fr-NC' => 'французский (Новая Каледония)',
        'fr-NE' => 'французский (Нигер)',
        'fr-PF' => 'французский (Французская Полинезия)',
        'fr-PM' => 'французский (Сен-Пьер и Микелон)',
        'fr-RE' => 'французский (Реюньон)',
        'fr-RW' => 'французский (Руанда)',
        'fr-SC' => 'французский (Сейшельские Острова)',
        'fr-SN' => 'французский (Сенегал)',
        'fr-SY' => 'французский (Сирия)',
        'fr-TD' => 'французский (Чад)',
        'fr-TG' => 'французский (Того)',
        'fr-TN' => 'французский (Тунис)',
        'fr-VU' => 'французский (Вануату)',
        'fr-WF' => 'французский (Уоллис и Футуна)',
        'fr-YT' => 'французский (Майотта)',
        'fur' => 'фриульский',
        'fur-IT' => 'фриульский (Италия)',
        'fy' => 'западнофризский',
        'fy-NL' => 'западнофризский (Нидерланды)',
        'ga' => 'ирландский',
        'ga-IE' => 'ирландский (Ирландия)',
        'gd' => 'гэльский',
        'gd-GB' => 'гэльский (Великобритания)',
        'gl' => 'галисийский',
        'gl-ES' => 'галисийский (Испания)',
        'gsw' => 'швейцарский немецкий',
        'gsw-CH' => 'швейцарский немецкий (Швейцария)',
        'gsw-FR' => 'швейцарский немецкий (Франция)',
        'gsw-LI' => 'швейцарский немецкий (Лихтенштейн)',
        'gu' => 'гуджарати',
        'gu-IN' => 'гуджарати (Индия)',
        'guz' => 'гусии',
        'guz-KE' => 'гусии (Кения)',
        'gv' => 'мэнский',
        'gv-IM' => 'мэнский (о-в Мэн)',
        'ha' => 'хауса',
        'ha-GH' => 'хауса (Гана)',
        'ha-NE' => 'хауса (Нигер)',
        'ha-NG' => 'хауса (Нигерия)',
        'haw' => 'гавайский',
        'haw-US' => 'гавайский (Соединенные Штаты)',
        'he' => 'иврит',
        'he-IL' => 'иврит (Израиль)',
        'hi' => 'хинди',
        'hi-IN' => 'хинди (Индия)',
        'hr' => 'хорватский',
        'hr-BA' => 'хорватский (Босния и Герцеговина)',
        'hr-HR' => 'хорватский (Хорватия)',
        'hsb' => 'верхнелужицкий',
        'hsb-DE' => 'верхнелужицкий (Германия)',
        'hu' => 'венгерский',
        'hu-HU' => 'венгерский (Венгрия)',
        'hy' => 'армянский',
        'hy-AM' => 'армянский (Армения)',
        'ia' => 'интерлингва',
        'ia-001' => 'интерлингва (весь мир)',
        'id' => 'индонезийский',
        'id-ID' => 'индонезийский (Индонезия)',
        'ig' => 'игбо',
        'ig-NG' => 'игбо (Нигерия)',
        'ii' => 'носу',
        'ii-CN' => 'носу (Китай)',
        'is' => 'исландский',
        'is-IS' => 'исландский (Исландия)',
        'it' => 'итальянский',
        'it-CH' => 'итальянский (Швейцария)',
        'it-IT' => 'итальянский (Италия)',
        'it-SM' => 'итальянский (Сан-Марино)',
        'it-VA' => 'итальянский (Ватикан)',
        'ja' => 'японский',
        'ja-JP' => 'японский (Япония)',
        'jgo' => 'нгомба',
        'jgo-CM' => 'нгомба (Камерун)',
        'jmc' => 'мачаме',
        'jmc-TZ' => 'мачаме (Танзания)',
        'jv' => 'яванский',
        'jv-ID' => 'яванский (Индонезия)',
        'ka' => 'грузинский',
        'ka-GE' => 'грузинский (Грузия)',
        'kab' => 'кабильский',
        'kab-DZ' => 'кабильский (Алжир)',
        'kam' => 'камба',
        'kam-KE' => 'камба (Кения)',
        'kde' => 'маконде',
        'kde-TZ' => 'маконде (Танзания)',
        'kea' => 'кабувердьяну',
        'kea-CV' => 'кабувердьяну (Кабо-Верде)',
        'khq' => 'койра чиини',
        'khq-ML' => 'койра чиини (Мали)',
        'ki' => 'кикуйю',
        'ki-KE' => 'кикуйю (Кения)',
        'kk' => 'казахский',
        'kk-KZ' => 'казахский (Казахстан)',
        'kkj' => 'како',
        'kkj-CM' => 'како (Камерун)',
        'kl' => 'гренландский',
        'kl-GL' => 'гренландский (Гренландия)',
        'kln' => 'календжин',
        'kln-KE' => 'календжин (Кения)',
        'km' => 'кхмерский',
        'km-KH' => 'кхмерский (Камбоджа)',
        'kn' => 'каннада',
        'kn-IN' => 'каннада (Индия)',
        'ko' => 'корейский',
        'ko-KP' => 'корейский (КНДР)',
        'ko-KR' => 'корейский (Республика Корея)',
        'kok' => 'конкани',
        'kok-IN' => 'конкани (Индия)',
        'ks' => 'кашмири',
        'ks-IN' => 'кашмири (Индия)',
        'ksb' => 'шамбала',
        'ksb-TZ' => 'шамбала (Танзания)',
        'ksf' => 'бафия',
        'ksf-CM' => 'бафия (Камерун)',
        'ksh' => 'кёльнский',
        'ksh-DE' => 'кёльнский (Германия)',
        'ku' => 'курдский',
        'ku-TR' => 'курдский (Турция)',
        'kw' => 'корнский',
        'kw-GB' => 'корнский (Великобритания)',
        'ky' => 'киргизский',
        'ky-KG' => 'киргизский (Киргизия)',
        'lag' => 'ланго',
        'lag-TZ' => 'ланго (Танзания)',
        'lb' => 'люксембургский',
        'lb-LU' => 'люксембургский (Люксембург)',
        'lg' => 'ганда',
        'lg-UG' => 'ганда (Уганда)',
        'lkt' => 'лакота',
        'lkt-US' => 'лакота (Соединенные Штаты)',
        'ln' => 'лингала',
        'ln-AO' => 'лингала (Ангола)',
        'ln-CD' => 'лингала (Конго - Киншаса)',
        'ln-CF' => 'лингала (Центрально-Африканская Республика)',
        'ln-CG' => 'лингала (Конго - Браззавиль)',
        'lo' => 'лаосский',
        'lo-LA' => 'лаосский (Лаос)',
        'lrc' => 'севернолурский',
        'lrc-IQ' => 'севернолурский (Ирак)',
        'lrc-IR' => 'севернолурский (Иран)',
        'lt' => 'литовский',
        'lt-LT' => 'литовский (Литва)',
        'lu' => 'луба-катанга',
        'lu-CD' => 'луба-катанга (Конго - Киншаса)',
        'luo' => 'луо',
        'luo-KE' => 'луо (Кения)',
        'luy' => 'лухья',
        'luy-KE' => 'лухья (Кения)',
        'lv' => 'латышский',
        'lv-LV' => 'латышский (Латвия)',
        'mas' => 'масаи',
        'mas-KE' => 'масаи (Кения)',
        'mas-TZ' => 'масаи (Танзания)',
        'mer' => 'меру',
        'mer-KE' => 'меру (Кения)',
        'mfe' => 'маврикийский креольский',
        'mfe-MU' => 'маврикийский креольский (Маврикий)',
        'mg' => 'малагасийский',
        'mg-MG' => 'малагасийский (Мадагаскар)',
        'mgh' => 'макуа-меетто',
        'mgh-MZ' => 'макуа-меетто (Мозамбик)',
        'mgo' => 'мета',
        'mgo-CM' => 'мета (Камерун)',
        'mi' => 'маори',
        'mi-NZ' => 'маори (Новая Зеландия)',
        'mk' => 'македонский',
        'mk-MK' => 'македонский (Северная Македония)',
        'ml' => 'малаялам',
        'ml-IN' => 'малаялам (Индия)',
        'mn' => 'монгольский',
        'mn-MN' => 'монгольский (Монголия)',
        'mr' => 'маратхи',
        'mr-IN' => 'маратхи (Индия)',
        'ms' => 'малайский',
        'ms-BN' => 'малайский (Бруней-Даруссалам)',
        'ms-MY' => 'малайский (Малайзия)',
        'ms-SG' => 'малайский (Сингапур)',
        'mt' => 'мальтийский',
        'mt-MT' => 'мальтийский (Мальта)',
        'mua' => 'мунданг',
        'mua-CM' => 'мунданг (Камерун)',
        'my' => 'бирманский',
        'my-MM' => 'бирманский (Мьянма [Бирма])',
        'mzn' => 'мазендеранский',
        'mzn-IR' => 'мазендеранский (Иран)',
        'naq' => 'нама',
        'naq-NA' => 'нама (Намибия)',
        'nb' => 'норвежский букмол',
        'nb-NO' => 'норвежский букмол (Норвегия)',
        'nb-SJ' => 'норвежский букмол (Шпицберген и Ян-Майен)',
        'nd' => 'северный ндебеле',
        'nd-ZW' => 'северный ндебеле (Зимбабве)',
        'nds' => 'нижнегерманский',
        'nds-DE' => 'нижнегерманский (Германия)',
        'nds-NL' => 'нижнегерманский (Нидерланды)',
        'ne' => 'непальский',
        'ne-IN' => 'непальский (Индия)',
        'ne-NP' => 'непальский (Непал)',
        'nl' => 'нидерландский',
        'nl-AW' => 'нидерландский (Аруба)',
        'nl-BE' => 'нидерландский (Бельгия)',
        'nl-BQ' => 'нидерландский (Бонэйр, Синт-Эстатиус и Саба)',
        'nl-CW' => 'нидерландский (Кюрасао)',
        'nl-NL' => 'нидерландский (Нидерланды)',
        'nl-SR' => 'нидерландский (Суринам)',
        'nl-SX' => 'нидерландский (Синт-Мартен)',
        'nmg' => 'квасио',
        'nmg-CM' => 'квасио (Камерун)',
        'nn' => 'нюнорск',
        'nn-NO' => 'нюнорск (Норвегия)',
        'nnh' => 'нгиембунд',
        'nnh-CM' => 'нгиембунд (Камерун)',
        'nus' => 'нуэр',
        'nus-SS' => 'нуэр (Южный Судан)',
        'nyn' => 'ньянколе',
        'nyn-UG' => 'ньянколе (Уганда)',
        'om' => 'оромо',
        'om-ET' => 'оромо (Эфиопия)',
        'om-KE' => 'оромо (Кения)',
        'or' => 'ория',
        'or-IN' => 'ория (Индия)',
        'os' => 'осетинский',
        'os-GE' => 'осетинский (Грузия)',
        'os-RU' => 'осетинский (Россия)',
        'pa' => 'панджаби',
        'pa-Arab' => 'панджаби (арабица)',
        'pa-Arab-PK' => 'панджаби (арабица, Пакистан)',
        'pa-Guru' => 'панджаби (гурмукхи)',
        'pa-Guru-IN' => 'панджаби (гурмукхи, Индия)',
        'pl' => 'польский',
        'pl-PL' => 'польский (Польша)',
        'ps' => 'пушту',
        'ps-AF' => 'пушту (Афганистан)',
        'ps-PK' => 'пушту (Пакистан)',
        'pt' => 'португальский',
        'pt-AO' => 'португальский (Ангола)',
        'pt-BR' => 'португальский (Бразилия)',
        'pt-CH' => 'португальский (Швейцария)',
        'pt-CV' => 'португальский (Кабо-Верде)',
        'pt-GQ' => 'португальский (Экваториальная Гвинея)',
        'pt-GW' => 'португальский (Гвинея-Бисау)',
        'pt-LU' => 'португальский (Люксембург)',
        'pt-MO' => 'португальский (Макао [САР])',
        'pt-MZ' => 'португальский (Мозамбик)',
        'pt-PT' => 'португальский (Португалия)',
        'pt-ST' => 'португальский (Сан-Томе и Принсипи)',
        'pt-TL' => 'португальский (Восточный Тимор)',
        'qu' => 'кечуа',
        'qu-BO' => 'кечуа (Боливия)',
        'qu-EC' => 'кечуа (Эквадор)',
        'qu-PE' => 'кечуа (Перу)',
        'rm' => 'романшский',
        'rm-CH' => 'романшский (Швейцария)',
        'rn' => 'рунди',
        'rn-BI' => 'рунди (Бурунди)',
        'ro' => 'румынский',
        'ro-MD' => 'румынский (Молдова)',
        'ro-RO' => 'румынский (Румыния)',
        'rof' => 'ромбо',
        'rof-TZ' => 'ромбо (Танзания)',
        'ru' => 'русский',
        'ru-BY' => 'русский (Беларусь)',
        'ru-KG' => 'русский (Киргизия)',
        'ru-KZ' => 'русский (Казахстан)',
        'ru-MD' => 'русский (Молдова)',
        'ru-RU' => 'русский (Россия)',
        'ru-UA' => 'русский (Украина)',
        'rw' => 'киньяруанда',
        'rw-RW' => 'киньяруанда (Руанда)',
        'rwk' => 'руанда',
        'rwk-TZ' => 'руанда (Танзания)',
        'sah' => 'саха',
        'sah-RU' => 'саха (Россия)',
        'saq' => 'самбуру',
        'saq-KE' => 'самбуру (Кения)',
        'sbp' => 'сангу',
        'sbp-TZ' => 'сангу (Танзания)',
        'sd' => 'синдхи',
        'sd-PK' => 'синдхи (Пакистан)',
        'se' => 'северносаамский',
        'se-FI' => 'северносаамский (Финляндия)',
        'se-NO' => 'северносаамский (Норвегия)',
        'se-SE' => 'северносаамский (Швеция)',
        'seh' => 'сена',
        'seh-MZ' => 'сена (Мозамбик)',
        'ses' => 'койраборо сенни',
        'ses-ML' => 'койраборо сенни (Мали)',
        'sg' => 'санго',
        'sg-CF' => 'санго (Центрально-Африканская Республика)',
        'shi' => 'ташельхит',
        'shi-Latn' => 'ташельхит (латиница)',
        'shi-Latn-MA' => 'ташельхит (латиница, Марокко)',
        'shi-Tfng' => 'ташельхит (древнеливийская)',
        'shi-Tfng-MA' => 'ташельхит (древнеливийская, Марокко)',
        'si' => 'сингальский',
        'si-LK' => 'сингальский (Шри-Ланка)',
        'sk' => 'словацкий',
        'sk-SK' => 'словацкий (Словакия)',
        'sl' => 'словенский',
        'sl-SI' => 'словенский (Словения)',
        'smn' => 'инари-саамский',
        'smn-FI' => 'инари-саамский (Финляндия)',
        'sn' => 'шона',
        'sn-ZW' => 'шона (Зимбабве)',
        'so' => 'сомали',
        'so-DJ' => 'сомали (Джибути)',
        'so-ET' => 'сомали (Эфиопия)',
        'so-KE' => 'сомали (Кения)',
        'so-SO' => 'сомали (Сомали)',
        'sq' => 'албанский',
        'sq-AL' => 'албанский (Албания)',
        'sq-MK' => 'албанский (Северная Македония)',
        'sq-XK' => 'албанский (Косово)',
        'sr' => 'сербский',
        'sr-Cyrl' => 'сербский (кириллица)',
        'sr-Cyrl-BA' => 'сербский (кириллица, Босния и Герцеговина)',
        'sr-Cyrl-ME' => 'сербский (кириллица, Черногория)',
        'sr-Cyrl-RS' => 'сербский (кириллица, Сербия)',
        'sr-Cyrl-XK' => 'сербский (кириллица, Косово)',
        'sr-Latn' => 'сербский (латиница)',
        'sr-Latn-BA' => 'сербский (латиница, Босния и Герцеговина)',
        'sr-Latn-ME' => 'сербский (латиница, Черногория)',
        'sr-Latn-RS' => 'сербский (латиница, Сербия)',
        'sr-Latn-XK' => 'сербский (латиница, Косово)',
        'sv' => 'шведский',
        'sv-AX' => 'шведский (Аландские о-ва)',
        'sv-FI' => 'шведский (Финляндия)',
        'sv-SE' => 'шведский (Швеция)',
        'sw' => 'суахили',
        'sw-CD' => 'суахили (Конго - Киншаса)',
        'sw-KE' => 'суахили (Кения)',
        'sw-TZ' => 'суахили (Танзания)',
        'sw-UG' => 'суахили (Уганда)',
        'ta' => 'тамильский',
        'ta-IN' => 'тамильский (Индия)',
        'ta-LK' => 'тамильский (Шри-Ланка)',
        'ta-MY' => 'тамильский (Малайзия)',
        'ta-SG' => 'тамильский (Сингапур)',
        'te' => 'телугу',
        'te-IN' => 'телугу (Индия)',
        'teo' => 'тесо',
        'teo-KE' => 'тесо (Кения)',
        'teo-UG' => 'тесо (Уганда)',
        'tg' => 'таджикский',
        'tg-TJ' => 'таджикский (Таджикистан)',
        'th' => 'тайский',
        'th-TH' => 'тайский (Таиланд)',
        'ti' => 'тигринья',
        'ti-ER' => 'тигринья (Эритрея)',
        'ti-ET' => 'тигринья (Эфиопия)',
        'tk' => 'туркменский',
        'tk-TM' => 'туркменский (Туркменистан)',
        'to' => 'тонганский',
        'to-TO' => 'тонганский (Тонга)',
        'tr' => 'турецкий',
        'tr-CY' => 'турецкий (Кипр)',
        'tr-TR' => 'турецкий (Турция)',
        'tt' => 'татарский',
        'tt-RU' => 'татарский (Россия)',
        'twq' => 'тасавак',
        'twq-NE' => 'тасавак (Нигер)',
        'tzm' => 'среднеатласский тамазигхтский',
        'tzm-MA' => 'среднеатласский тамазигхтский (Марокко)',
        'ug' => 'уйгурский',
        'ug-CN' => 'уйгурский (Китай)',
        'uk' => 'украинский',
        'uk-UA' => 'украинский (Украина)',
        'ur' => 'урду',
        'ur-IN' => 'урду (Индия)',
        'ur-PK' => 'урду (Пакистан)',
        'uz' => 'узбекский',
        'uz-Arab' => 'узбекский (арабица)',
        'uz-Arab-AF' => 'узбекский (арабица, Афганистан)',
        'uz-Cyrl' => 'узбекский (кириллица)',
        'uz-Cyrl-UZ' => 'узбекский (кириллица, Узбекистан)',
        'uz-Latn' => 'узбекский (латиница)',
        'uz-Latn-UZ' => 'узбекский (латиница, Узбекистан)',
        'vai' => 'ваи',
        'vai-Latn' => 'ваи (латиница)',
        'vai-Latn-LR' => 'ваи (латиница, Либерия)',
        'vai-Vaii' => 'ваи (вайская)',
        'vai-Vaii-LR' => 'ваи (вайская, Либерия)',
        'vi' => 'вьетнамский',
        'vi-VN' => 'вьетнамский (Вьетнам)',
        'vun' => 'вунджо',
        'vun-TZ' => 'вунджо (Танзания)',
        'wae' => 'валлисский',
        'wae-CH' => 'валлисский (Швейцария)',
        'wo' => 'волоф',
        'wo-SN' => 'волоф (Сенегал)',
        'xh' => 'коса',
        'xh-ZA' => 'коса (Южно-Африканская Республика)',
        'xog' => 'сога',
        'xog-UG' => 'сога (Уганда)',
        'yav' => 'янгбен',
        'yav-CM' => 'янгбен (Камерун)',
        'yi' => 'идиш',
        'yi-001' => 'идиш (весь мир)',
        'yo' => 'йоруба',
        'yo-BJ' => 'йоруба (Бенин)',
        'yo-NG' => 'йоруба (Нигерия)',
        'yue' => 'кантонский',
        'yue-Hans' => 'кантонский (упрощенная китайская)',
        'yue-Hans-CN' => 'кантонский (упрощенная китайская, Китай)',
        'yue-Hant' => 'кантонский (традиционная китайская)',
        'yue-Hant-HK' => 'кантонский (традиционная китайская, Гонконг [САР])',
        'zgh' => 'тамазигхтский',
        'zgh-MA' => 'тамазигхтский (Марокко)',
        'zh' => 'китайский',
        'zh-Hans' => 'китайский (упрощенная китайская)',
        'zh-Hans-CN' => 'китайский (упрощенная китайская, Китай)',
        'zh-Hans-HK' => 'китайский (упрощенная китайская, Гонконг [САР])',
        'zh-Hans-MO' => 'китайский (упрощенная китайская, Макао [САР])',
        'zh-Hans-SG' => 'китайский (упрощенная китайская, Сингапур)',
        'zh-Hant' => 'китайский (традиционная китайская)',
        'zh-Hant-HK' => 'китайский (традиционная китайская, Гонконг [САР])',
        'zh-Hant-MO' => 'китайский (традиционная китайская, Макао [САР])',
        'zh-Hant-TW' => 'китайский (традиционная китайская, Тайвань)',
        'zu' => 'зулу',
        'zu-ZA' => 'зулу (Южно-Африканская Республика)',
    ],
];
